# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 4
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR4_strategy.txt
# LLM Suggested Fallback: D

def benevolent_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    current_round = len(my_history)
    total_rounds = 10
    
    is_always_c = "return \"C\"" in opponent_program_code or "always_cooperate" in opponent_program_code.lower()
    is_always_d = "return \"D\"" in opponent_program_code or "always_defect" in opponent_program_code.lower()
    
    if is_always_c:
        return "D"
    if is_always_d:
        return "C" if random.random() < 0.1 else "D"
    
    if "harmonious_illusionist" in opponent_program_code:
        if current_round >= 8:
            return "D"
        if opp_history[-1] == "C":
            return "C" if random.random() < 0.8 else "D"
        else:
            return "D"
    
    if current_round >= total_rounds - 2 and "D" in opp_history:
        return "D"
    
    if opp_history[-1] == "C":
        return "C" if random.random() < 0.8 else "D"
    else:
        return "D" if random.random() < 0.7 else "C"